#!/usr/bin/env ruby

# ----------------------------------------------------------------------------
#  Unidirectional constraint network for logic gates
# ----------------------------------------------------------------------------

# This is a simple example of a constraint network that uses logic gates. 
# There are three classes of gates: AndGate, OrGate, and NotGate. 
# Connections between gates are modelled as the class Wire.

require 'logger'

class BinaryConstraint

  def initialize(input1, input2, output)
    @input1=input1
    @input1.add_constraint(self)
    @input2=input2
    @input2.add_constraint(self)
    @output=output
    new_value()
  end
  
end

class AndGate < BinaryConstraint
  
  def new_value
    sleep 0.2
    @output.value=(@input1.value and @input2.value)
  end
  
end

class OrGate < BinaryConstraint
    
  def new_value
    sleep 0.2
    @output.value=(@input1.value or @input2.value)
  end
  
end

class NotGate
  
  def initialize(input, output)
    @input=input
    @input.add_constraint(self)
    @output=output
    new_value
  end
  
  def new_value
    sleep 0.2
    @output.value=(not @input.value)
  end
  
end

class Wire
  
  attr_accessor :name
  attr_reader :value

  def initialize(name, value=false)
    @name=name
    @value=value
    @constraints=[]
    @logger=Logger.new(STDOUT)
  end
  
  def log_level=(level)
    @logger.level=level
  end
  
  def add_constraint(gate)
    @constraints << gate
  end
  
  def value=(value)
    @logger.debug("#{name} = #{value}")
    @value=value
    @constraints.each { |c| c.new_value }
  end
  
end

# When you use test_constraints, it will prompt you for input before
# proceeding. That way you can analyze what happens in the code before
# you go on. You only need to press 'Enter' to continue.

def test_constraints
  a=Wire.new('a')
  b=Wire.new('b')
  c=Wire.new('c')

  # If you don't want to see when c changes value, set the log_level of c to
  # Logger::WARN. Default is Logger::DEBUG which will show all messages.
  c.log_level=Logger::DEBUG

  puts "Testing the AND gate"
  andGate=AndGate.new(a, b, c)
  a.value=true
  gets
  b.value=true
  gets
  a.value=false
  gets

  a=Wire.new('a')
  b=Wire.new('b')
  c=Wire.new('c')

  puts "Testing the OR gate"
  orGate=OrGate.new(a, b, c)
  a.value=false
  gets  
  b.value=false
  gets

  :ok
end

def my_test
  $a = Wire.new('a')
  $b = Wire.new('b')
  $c = Wire.new('c')
  d = Wire.new('d')
  e = Wire.new('e')
  $r = Wire.new('r')
  
  ng = NotGate.new($c,e)
  og = OrGate.new($a,$b,d)
  ag = AndGate.new(d,e,$r)

  :ok
end

class Creader

  def Creader.load(filename)
    creader = new
    creader.instance_eval(File.read(filename))
  end
 
  def method_missing(name,*args)
    puts "method missing called => name: #{name}, args: #{args}"
  end
end

Creader.load("dsl.rb")
