#include <iostream>
#include <string>
#include <unistd.h>
#include <pwd.h>

void print_uid() {
	uid_t uid = getuid();
	struct passwd *p = getpwuid(uid);
	std::cout << "uid=" << uid << ", I am " << p->pw_name << std::endl;
}

const std::string secret_path = "/home/filip/secret/";

void output_file(const std::string &file) {
	std::string path = secret_path + file;
	execl("/usr/bin/cat", "cat", path.c_str(), nullptr);
}

void list_files() {
	execl("/usr/bin/ls", "ls", "-l", secret_path.c_str(), nullptr);
}

int main(int argc, const char *argv[]) {
	print_uid();

	if (setuid(0) != 0) {
		perror("setuid");
	}

	print_uid();

	if (argc > 1) {
		output_file(argv[1]);
	} else {
		list_files();
	}

	return 0;
}
