#include <iostream>
#include <string>
#include <unistd.h>
#include <pwd.h>

void print_uid() {
	uid_t uid = getuid();
	struct passwd *p = getpwuid(uid);
	std::cout << "uid=" << uid << ", I am " << p->pw_name << std::endl;
}

const std::string secret_path = "/home/filip/secret/";

void output_file(const std::string &file) {
	std::string cmd = "cat " + secret_path + file;
	system(cmd.c_str());
}

void list_files() {
	std::string cmd = "ls -l " + secret_path;
	system(cmd.c_str());
}

int main(int argc, const char *argv[]) {
	print_uid();

	if (setuid(0) != 0) {
		perror("setuid");
	}

	print_uid();

	if (argc > 1) {
		output_file(argv[1]);
	} else {
		list_files();
	}

	return 0;
}
