#include <iostream>
#include <unistd.h>
#include <fcntl.h>

int main() {
	{
		std::cout << "Försöker öppna 'rw.txt' för att läsa..." << std::endl;

		int fd = open("rw.txt", O_RDONLY);

		std::cout << "Öppnade filen, fd=" << fd << std::endl;

		char buffer[128];
		ssize_t data = read(fd, buffer, 127);
		if (data < 0)
			data = 0;
		buffer[data] = 0;
		std::cout << "Läste " << data << " bytes" << std::endl;
		std::cout << buffer << std::endl;

		close(fd);
	}

	{
		std::cout << "Försöker öppna 'rw.txt' för att skriva..." << std::endl;

		int fd = open("rw.txt", O_WRONLY | O_TRUNC);

		std::cout << "Öppnade filen, fd=" << fd << std::endl;

		ssize_t data = write(fd, "after\n", 6);

		std::cout << "Skrev " << data << " bytes" << std::endl;

		close(fd);
	}

	return 0;
}
