#include <iostream>
#include <sys/mman.h>
#include <unistd.h>

int readline(char *buffer) {
	int pos = 0;
	char input;
	while (std::cin) {
		input = std::cin.get();
		if (input == '\n') {
			buffer[pos] = 0;
			break;
		} else {
			buffer[pos] = input;
		}
		pos++;
	}
	return pos;
}

void unprotect_stack(void *ptr) {
	size_t pagesize = sysconf(_SC_PAGE_SIZE);
	size_t addr = size_t(ptr);
	addr &= ~(pagesize - 1);
	if (mprotect((void *)addr, pagesize, PROT_READ | PROT_WRITE | PROT_EXEC | PROT_GROWSDOWN)) {
		perror("mprotect");
	}
}

int main() {
	char buffer[128];
	std::cout << "Läser sträng till buffer: " << (void *)buffer << std::endl;
	unprotect_stack(buffer);

	int total = readline(buffer);

	std::cout << "Läste " << total << " tecken: " << buffer << std::endl;

	return 0;
}
