#include <iostream>
#include <cstring> // memset
#include <unistd.h> // sleep
#include <sys/mman.h> // mmap

int main() {
	const size_t step = 1024 * 1024 * 1024;

	for (size_t i = 0; i < 14; i++) {
		void *memory = mmap(nullptr, step, PROT_READ | PROT_WRITE, MAP_PRIVATE | MAP_ANONYMOUS, 0, 0);
		// This is important. Why?
		memset(memory, 0, step);

		std::cout << "Allocated " << (i + 1) << " GiB memory." << std::endl;
	}

	std::cout << "Sleeping for 30 seconds..." << std::endl;
	sleep(30);

	return 0;
}
