#include "dump.h"
#include <iostream>
#include <typeinfo>

using namespace std;

struct base {
	virtual ~base() = default;

	int data{0x1020};

	virtual void fun(int x) = 0;
};

struct derived : base {
	void fun(int x) override {
		cout << "Total: " << (x + data) << endl;
	}
};

// begin info:
const type_info &find_typeinfo(base &var) {
	return typeid(var);
}
// end info

int main() {
	derived d;
	dump_pointers(d);
	dump_vtable(d, 4);
	dump_full_vtable(d, 4);

	cout << "Type: " << find_typeinfo(d).name() << endl;

	return 0;
}
