#pragma once

#include <string>
#include <limits.h>
#include <backtrace.h>

/**
 * Symbol information from pointers.
 */
class Syminfo {
public:
	// Lookup symbol information.
	std::string lookup(void *ptr) const;

	// Global instance.
	static Syminfo info;
private:
	Syminfo();

	char name[PATH_MAX + 1];
	backtrace_state *state;
};

// Use the above class for syminfo.
std::string syminfo(void *ptr);
