#include "syminfo.h"
#include <cxxabi.h>
#include <unistd.h>
#include <iostream>

using std::cout;
using std::endl;

static void backtrace_error(void *, const char *msg, int errnum) {
	cout << "Error interfacing with backtrace: " << msg << " (" << errnum << ")" << endl;
}

static void backtrace_ok(void *data, uintptr_t /* pc */, const char *symname, uintptr_t /* symval */, uintptr_t /* symsize */) {
	std::string *output = reinterpret_cast<std::string *>(data);

	if (!symname) {
		*output = "<unknown>";
		return;
	}

	int status = 0;
	char *demangled = abi::__cxa_demangle(symname, nullptr, nullptr, &status);
	if (status == 0) {
		*output = demangled;
	} else {
		*output = symname;
	}
	free(demangled);
}

Syminfo Syminfo::info;

Syminfo::Syminfo() {
	readlink("/proc/self/exe", name, PATH_MAX);
	state = backtrace_create_state(name, 1, &backtrace_error, nullptr);
}

std::string Syminfo::lookup(void *data) const {
	std::string output;
	backtrace_syminfo(state, (uintptr_t)data, &backtrace_ok, &backtrace_error, &output);
	return output;
}

std::string syminfo(void *ptr) {
	return Syminfo::info.lookup(ptr);
}

