#include "dump.h"
#include <iostream>

using std::cout;

// begin simple:
struct simple {
	int a{1};
	int b{2};
	int c{3};
	long d{100};
	int e{4};
};
// end simple

// Like "simple" above, but re-arranged to be smaller.
struct compact {
	int a{1};
	int b{2};
	int c{3};
	int e{4};
	long d{100};
};

// Even worse with respect to padding...
struct much_pad {
	bool a{false};
	long b{10};
	bool c{true};
};

// Smaller alignment, since we don't contain "large" types.
struct small_alignment {
	int a{1};
	int b{2};
	int c{3};
};

// Contains an other type.
struct contained_single {
	simple a;
	int b{40};
};

// Contains other types.
struct contained_multi {
	simple a;
	small_alignment b;
	int c{40};
};

void simple_cases() {
	cout << "Simple:\n";
	dump_numeric(simple());

	cout << "Compact:\n";
	dump_numeric(compact());

	cout << "Much pad:\n";
	dump_numeric(much_pad());

	cout << "Small alignment:\n";
	dump_numeric(small_alignment());

	cout << "Contained types:\n";
	dump_numeric(contained_single());
	dump_numeric(contained_multi());
}

void arrays() {
	cout << "Array of simple:\n";
	simple simple_arr[2];
	dump_numeric(simple_arr);

	cout << "Array of small alignment:\n";
	small_alignment small_arr[2];
	dump_numeric(small_arr);
}

struct more_compact : compact {
	int extra{40};
};

// Note that this differs from "contained_single".
struct more_simple : simple {
	int extra{40};
};

// Multiple inheritance. Note that this differs from "contained_multi".
struct multi : simple, small_alignment {
	int extra{40};
};

void inheritance() {
	cout << "More compact:\n";
	dump_numeric(more_compact());

	cout << "More simple:\n";
	dump_numeric(more_simple());

	// Note: sizeof(simple) == sizeof(more_simple)!

	cout << "Multiple inheritance:\n";
	dump_numeric(multi());
}

int main() {
	simple_cases();

	arrays();

	inheritance();

	return 0;
}
