// begin decl:
struct member_ptr {
	// Pointer or vtable offset
	size_t ptr;

	// Object offset
	size_t offset;
};
// end decl

// begin call:
void member_call(MyClass &c, member_ptr ptr) {
	void *obj = (void *)&c + ptr.offset;
	void *target = ptr.ptr;
	// Is it a vtable offset?
	if (ptr.ptr & 0x1) {
		void *vtable = *(void **)obj;
		target = *(size_t *)(vtable + ptr - 1);
	}
	// Call the function!
	(obj->*target)();
}
// end call
