#include "dump.h"
#include <iostream>

using namespace std;

struct MyClass {
	virtual ~MyClass() = default;

	int data{};

	static int static_member() { return 0; }
	int normal_member() { return 1; }
	virtual int virtual_member() { return 2; }
	virtual int virtual_member2() { return 3; }
};

typedef int (*plain_ptr)();
typedef int (MyClass::*member_ptr)();

int call_member(MyClass &c, member_ptr ptr) {
	return (c.*ptr)();
}

int main() {
	// begin pointers:
	plain_ptr  x = &MyClass::static_member;
	member_ptr y = &MyClass::normal_member;
	member_ptr z = &MyClass::virtual_member;
	// end pointers
	member_ptr w = &MyClass::virtual_member2;

	// Note: Different sizes!
	dump_pointers(x);
	dump_pointers(y);
	dump_pointers(z);
	dump_pointers(w);

	MyClass c;
	// Dump vtable!
	dump_vtable(c, 4);

	cout << "Calling y: " << call_member(c, y) << endl;
	cout << "Calling z: " << call_member(c, z) << endl;
	cout << "Calling w: " << call_member(c, w) << endl;

	return 0;
}
