#pragma once

#include <vector>
#include "column.h"

using Columns = std::vector<Column>;

// Column setup suitable for numeric data.
Columns numeric();

// Column setup suitable for pointer data.
Columns pointer();

void dump_memory(const void *memory, size_t size, size_t adjust_offset, const Columns &cols);
void dump_memory(const void *memory, size_t size, const Columns &cols);
void dump_memory(const void *start, void *end, const Columns &cols);

template <class T>
void dump(const T &object, const Columns &cols) {
	dump_memory(&object, sizeof(T), cols);
}

template <class T>
void dump_numeric(const T &object) {
	dump(object, numeric());
}

template <class T>
void dump_pointers(const T &object) {
	dump(object, pointer());
}


template <class T>
void dump_vtable(const T &object, size_t entries) {
	void *vtable = *reinterpret_cast<void *const*>(&object);
	dump_memory(vtable, sizeof(void *) * entries, pointer());
}

template <class T>
void dump_full_vtable(const T &object, size_t entries) {
	void *vtable = *reinterpret_cast<void *const*>(&object);
	vtable = reinterpret_cast<void **>(vtable) - 2;
	dump_memory(vtable, sizeof(void *) * (entries + 2), -2*sizeof(void *), pointer());
}
