#pragma once

#include "column.h"

/**
 * This file implements the columns used in 'dump.cpp'.
 */

namespace columns {

	// Show the offset.
	Column offset();

	// Show all bytes in the row.
	Column bytes();

	// Show the contents as a 32-bit integer.
	Column low_int();
	Column high_int();

	// Show the contents as 64-bit integers.
	Column word();

	// Show the contents as a resolved pointer.
	Column pointer();

	// Show the contents of a pointer using its symbolic name.
	Column symbol();
}
