#pragma once

#include <functional>
#include <iostream>

using byte = unsigned char;

// Description of the source data for a row that is being generated.
struct RowInfo {
	// Offset in the entire chunk.
	size_t offset;

	// Start of the data for this row.
	const byte *data;

	// Size of the data for this row.
	size_t size;
};

// Information about a column.
struct Column {
	typedef std::ios_base &(*Align)(std::ios_base &);
	typedef std::function<void(std::ostream &, RowInfo)> Generator;

	// Create.
	Column(const std::string &header, Align align, const Generator &generator)
		: header(header), align(align), generator(generator) {}

	// Header text. Always left-aligned.
	std::string header;

	// Cell alignment (std::left or std::right).
	Align align;

	// Generator for cells.
	Generator generator;
};
